library(ggplot2)
library(ggpubr)
library(cowplot)
library(reshape2)
args=commandArgs(T)
file <- args[1]
file1 <- args[2]
data <- read.csv(file,header = T)
rownames(data) <- data[,1]
test <- data[,c(7,8)]
test$B2 <- (test$B2_L1_I333.R1.new.sam)*10^6/16568982
test$B3 <- (test$B3_L1_I334.R1.new.sam)*10^6/17848752
test$B2 <- log((test$B2)+1)
test$B3 <- log((test$B3)+1)
p1 <- ggplot(test,aes(x=B2,y=B3))+geom_point(size=1,shape=15)+geom_smooth(method = lm)+theme_bw()+theme(panel.grid.major = element_blank(),panel.grid.minor = element_blank())+stat_cor()+scale_y_continuous(expand = c(0,0))+scale_x_continuous(expand = c(0,0))


test <- data[,c(9,10)]
test$B5 <- (test$B5_L1_I336.R1.new.sam)*10^6/16811276
test$B6_L1_I337.R1.new.sam <- (test$B6_L1_I337.R1.new.sam)*10^6/15485540
test$B5 <- log(test$B5+1)
test$B6 <- log(test$B6+1)
p2 <- ggplot(test,aes(x=B5,y=B6))+geom_point(size=1,shape=15)+geom_smooth(method = lm)+theme_bw()+theme(panel.grid.major = element_blank(),panel.grid.minor = element_blank())+stat_cor()+scale_y_continuous(expand = c(0,0))+scale_x_continuous(expand = c(0,0))


test <- data[,c(11,12)]
test$B10 <- test$B10_L1_I343.R1.new.sam*10^6/14186572
test$B12 <- test$B12_L1_I345.R1.new.sam*10^6/17638507
test$B10 <- log(test$B10+1)
test$B12 <- log(test$B12+1)
p3 <- ggplot(test,aes(x=B10,y=B12))+geom_point(size=1,shape=15)+geom_smooth(method = lm)+theme_bw()+theme(panel.grid.major = element_blank(),panel.grid.minor = element_blank())+stat_cor()+scale_y_continuous(expand = c(0,0))+scale_x_continuous(expand = c(0,0))

test <- data[,c(13,14)]
test$B14 <- test$B14_L1_I347.R1.new.sam*10^6/10378235
test$B15 <- test$B15_L1_I348.R1.new.sam*10^6/17489042
test$B14 <- log(test$B14+1)
test$B15 <- log(test$B15+1)
p4 <- ggplot(test,aes(x=B14,y=B15))+geom_point(size=1,shape=15)+geom_smooth(method = lm)+theme_bw()+theme(panel.grid.major = element_blank(),panel.grid.minor = element_blank())+stat_cor()+scale_y_continuous(expand = c(0,0))+scale_x_continuous(expand = c(0,0)) 

c <- plot_grid(p1,p2,p3,p4,nrow=2,ncol=2,align="hv")
pdf(file1,width=8,height=8)
c
dev.off()
